-- CastAway - by danboo
-- $Id: CastAway.lua,v 1.1 2004-12-03 23:21:52-05 danboo Exp danboo $

local _step_data = {}

function CastAway (cast_id, reset_timeout, ...)

   -- if we haven't seen the cast_id before, initialize the time and step
   if not _step_data[cast_id] then
      _step_data[cast_id] = {}
      _step_data[cast_id]['last_time'] = 0
      _step_data[cast_id]['cast_step'] = 1
   end

   local stepper = _step_data[cast_id]

   local now = GetTime()

   -- if the timeout has been reached, always revert to step 1
   if reset_timeout and now - stepper['last_time'] >= reset_timeout then
      stepper['cast_step'] = 1
   end

   -- update the time at which the this id was invoked
   stepper['last_time'] = now

   -- cast the appropriate spell
   CastSpellByName( arg[ stepper['cast_step'] ] )

   -- advance the step by one
   stepper['cast_step'] = stepper['cast_step'] + 1

   -- set the step back to 1 if we've overflown the total number
   if stepper['cast_step'] > table.getn( arg ) then
      stepper['cast_step'] = 1
   end

end
